package gov.va.med.mhv.integration.phr.stage.transfer;

import java.util.Date;

/**
 * StageReminder entity.
 * 
 */

public class StageStudy extends StageEntity {

	// Fields
	private Date extractDate;

	private String procedureName;

	private String studyIdUrn;

	private Date procedureDatePrecise;
	
	private String procedureDateImprecise;
	
	private int imageCount;
	
	private String event;
	
	private String report;
		
	// Constructors

	/**
	 * default constructor do not provide auto initialization since this class
	 * can be used in findByExample
	 */
	public StageStudy() {
		super();
	}

	/** minimal constructor */
	public StageStudy(Long oplock, Date createdDate, Date modifiedDate, String icn, String stationNumber,
			Long requestMsgCtrlId, String event) {
		super();
		this.oplock = oplock;
		this.createdDate = createdDate;
		this.modifiedDate = modifiedDate;
		this.extractDate = modifiedDate;
		this.icn = icn;
		this.stationNumber = stationNumber;
		this.requestMsgCtrlId = requestMsgCtrlId;
		this.event = event;
	}

	// Property accessors

	public Date getExtractDate() {
		return extractDate;
	}

	public void setExtractDate(Date extractDate) {
		this.extractDate = extractDate;
	}

	public String getRecordId() {
		return studyIdUrn;
	}

	public void setStudyIdUrn(String studyIdUrn) {
		this.studyIdUrn = doubleUnescapeHtml(studyIdUrn);
	}

	public String getProcedureName() {
		return procedureName;
	}

	public void setProcedureName(String procedureName) {
		this.procedureName = doubleUnescapeHtml(procedureName);
	}

	public Date getProcedureDatePrecise() {
		return procedureDatePrecise;
	}

	public void setProcedureDatePrecise(Date procedureDatePrecise) {
		this.procedureDatePrecise = procedureDatePrecise;
	}

	public String getProcedureDateImprecise() {
		return procedureDateImprecise;
	}

	public void setProcedureDateImprecise(String procedureDateImprecise) {
		this.procedureDateImprecise = procedureDateImprecise;
	}

	public String getStudyIdUrn() {
		return studyIdUrn;
	}

	public int getImageCount() {
		return imageCount;
	}

	public void setImageCount(int imageCount) {
		this.imageCount = imageCount;
	}

	public String getEvent() {
		return event;
	}

	public void setEvent(String event) {
		this.event = event;
	}

	public String getReport() {
		return report;
	}

	public void setReport(String report) {
		this.report = report;
	}

	@Override
	public boolean equals(Object obj) {
		boolean result = false;
		result = String.valueOf(obj).equalsIgnoreCase(String.valueOf(this));
		return result;
	}

	public void setAK(StageEntityAK ak) {
		this.icn = ak.getIcn();
		// Station number is excluded because it comes from the response not the
		// request
		// in the case of allergies.

		// this.stationNumber=ak.getStationNumber();
		this.requestMsgCtrlId = ak.getRequestMsgCtrlId();
		this.responseMsgCtrlId = ak.getResponseMsgCtrlId();
	}

}
